<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet version="1.1" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:MSHelp="http://msdn.microsoft.com/mshelp" xmlns:saxon="http://icl.com/saxon" xmlns:javaFile="javaFile:java.io.File" extension-element-prefixes="saxon javaFile" exclude-result-prefixes="saxon javaFile">
  <xsl:script language="java" implements-prefix="javaFile" src="java:java.io.File"/>
  <xsl:strip-space elements="*"/>
  <xsl:variable name="lc" select="'abcdefghijklmnopqrstuvwxyz'"/>
  <xsl:variable name="uc" select="'ABCDEFGHIJKLMNOPQRSTUVWXYZ'"/>
  <xsl:variable name="templateDir" select="templates"/>
  <xsl:variable name="contentDir" select="content"/>
  <xsl:include href="norm_hierarchy.xsl"/>
  <xsl:include href="norm_propertylinks2.xsl"/>
  <xsl:include href="norm_methodlinks2.xsl"/>
  <xsl:include href="norm_eventlinks.xsl"/>
  <xsl:include href="setupbuild.xsl"/>
  <!-- Always make sure you are calling apply-templates in each template
     so that children that are unexpected will be caught -->
  <!-- TODO: go through mergerules and make sure I understand everything and that everything is handled here -->
  <!-- TODO: overloaded property accessors! -->
  <!-- TODO: move flags from accessor method to the property? -->
  <!-- TODO: figure out why methodlinks does not need to open a file; should it? why are the differences between the three link finding stylesheets? -->
  <!-- ################## NAMESPACES ####################### -->
  <xsl:template match="/namespace">
    <xsl:variable name="publishnamespace">
    yes
  </xsl:variable>
    <xsl:if test="$publishnamespace!='no'">
      <xsl:variable name="outputfile">
        <xsl:call-template name="getoutputfile"/>
      </xsl:variable>
      <xsl:document method="xml" indent="yes" href="{$outputdir}/{$outputfile}">
        <!--
      <xsl:processing-instruction name="xml-stylesheet">
        <xsl:text>type="text/xsl" href="../displayCSS.xsl"</xsl:text>
      </xsl:processing-instruction>
      -->
        <namespace>
          <xsl:copy-of select="@*"/>
          <xsl:apply-templates/>
        </namespace>
      </xsl:document>
    </xsl:if>
  </xsl:template>
  <!-- ######## VARIABLES AND CONSTANTS ####### -->
  <xsl:template match="/namespace/variable | /namespace/const | /namespace/constant">
    <xsl:variable name="tmpname" select="@tmpname"/>
    <xsl:choose>
      <xsl:when test="preceding-sibling::variable[@name=$tmpname] | preceding-sibling::const[@name=$tmpname] | preceding-sibling::constant[@name=$tmpname]">
        <xsl:message>
      Duplicate <xsl:value-of select="@name"/>
        </xsl:message>
      </xsl:when>
      <xsl:otherwise>
        <xsl:variable name="publish">
    yes
  </xsl:variable>
        <xsl:if test="$publish!='no'">
          <xsl:variable name="name" select="name(.)"/>
          <xsl:element name="{$name}">
            <xsl:attribute name="namespace"><xsl:value-of select="ancestor::namespace/@name"/></xsl:attribute>
            <xsl:call-template name="copyattributesandsetvisibility"/>
            <xsl:apply-templates/>
          </xsl:element>
        </xsl:if>
      </xsl:otherwise>
    </xsl:choose>
   <xsl:apply-templates mode="templating" select="."/>
  </xsl:template>
  <!-- ######## TYPES: TYPE, POINTER, ARRAY, #######
     ######## CLASSREF, SET, ENUM ################ -->
  <xsl:template match="/namespace/enum | /namespace/set | /namespace/pointer
                     | /namespace/array | /namespace/classref | /namespace/type">
    <xsl:variable name="name" select="@name"/>
    <xsl:choose>
      <xsl:when test="preceding-sibling::enum[@name=$name]
                  | preceding-sibling::set[@name=$name]
                  | preceding-sibling::pointer[@name=$name]
                  | preceding-sibling::array[@name=$name]
                  | preceding-sibling::classref[@name=$name]
                  | preceding-sibling::type[@name=$name]">
        <xsl:message>
      Duplicate <xsl:value-of select="@name"/>
        </xsl:message>
      </xsl:when>
      <xsl:otherwise>
        <xsl:variable name="publish">
    yes
  </xsl:variable>
        <xsl:if test="$publish!='no'">
          <xsl:element name="type">
            <xsl:attribute name="variety"><xsl:value-of select="name(.)"/></xsl:attribute>
            <xsl:attribute name="namespace"><xsl:value-of select="ancestor::namespace/@name"/></xsl:attribute>
            <xsl:call-template name="copyattributesandsetvisibility"/>
            <!-- copy all attributes except namespace -->
            <!--<xsl:copy-of select = "@*[not(name()='namespace')]"/>-->
            <!-- namespace will be overwritten below (???) -->
            <xsl:attribute name="namespace"><xsl:value-of select="ancestor::namespace/@name"/></xsl:attribute>
            <xsl:if test="@alias">
              <xsl:attribute name="aliasnamespace"><xsl:value-of select="@namespace"/></xsl:attribute>
            </xsl:if>
            <xsl:apply-templates/>
          </xsl:element>
        </xsl:if>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="templating" select="."/>
  </xsl:template>
  <!-- ######## IMPLEMENTS LIST ################## -->
  <xsl:template match="implements">
    <xsl:if test="not(contains(@name,'$'))">
      <implements>
        <xsl:copy-of select="@name"/>
        <xsl:copy-of select="@namespace"/>
      </implements>
    </xsl:if>
  </xsl:template>
  <!-- ######### INTERFACES AND CLASSES AND ANOTHER TYPE: STRUCT ####### -->
  <xsl:template match="/namespace/interface | /namespace/class | /namespace/struct[not(preceding-sibling::struct) or @name != preceding-sibling::struct/@name] | /namespace/helper">
    <xsl:variable name="tmpname" select="@name"/>
    <xsl:variable name="previousnode" select="preceding-sibling::struct[@name=$tmpname][1] 
                                            | preceding-sibling::class[@name=$tmpname][1] 
                                            | preceding-sibling::interface[@name=$tmpname][1]"/>
    <xsl:choose>
      <xsl:when test="count(.)=count($previousnode) and count(.)=count(.|$previousnode)">
        <xsl:message>
        Duplicate <xsl:value-of select="@name"/>
        </xsl:message>
      </xsl:when>
      <xsl:when test="$previousnode">
        <xsl:message>
      Overloaded <xsl:value-of select="name(.)"/>: <xsl:value-of select="@name"/>
        </xsl:message>
      </xsl:when>
      <xsl:otherwise>
        <xsl:variable name="publish">
    yes
  </xsl:variable>
        <xsl:if test="$publish!='no'">
          <xsl:variable name="name">
            <xsl:choose>
              <xsl:when test="self::struct">
                <xsl:text>type</xsl:text>
              </xsl:when>
              <xsl:when test="not(self::struct)">
                <xsl:value-of select="name(.)"/>
              </xsl:when>
              <xsl:otherwise>
                <xsl:message>
              Unexpected element type: <xsl:value-of select="name(.)"/>
                </xsl:message>
              </xsl:otherwise>
            </xsl:choose>
          </xsl:variable>
          <xsl:element name="{$name}">
            <xsl:if test="self::struct">
              <xsl:attribute name="variety">struct</xsl:attribute>
            </xsl:if>
            <xsl:call-template name="copyattributesandsetvisibility"/>
            <!-- copy all attributes except namespace -->
            <!--<xsl:copy-of select = "@*[not(name()='namespace')]"/>-->
            <!-- namespace will be overwritten below (???) -->
            <xsl:attribute name="namespace"><xsl:value-of select="../@name"/></xsl:attribute>
            <xsl:if test="@alias">
              <xsl:attribute name="aliasnamespace"><xsl:value-of select="@namespace"/></xsl:attribute>
            </xsl:if>
            <xsl:if test="self::class | self::helper">
              <xsl:call-template name="hierarchy"/>
            </xsl:if>
            <xsl:if test="self::class | self::interface | self::helper">
              <xsl:if test="interfaces">
                <xsl:element name="interfaces">
                  <xsl:apply-templates select="interfaces"/>
                </xsl:element>
              </xsl:if>
            </xsl:if>
            <xsl:call-template name="syntax"/>
            <!-- methods with declaring_interface are not published, but properties with declaring_interface are published! Undocumented properties are weeded out in the property template, as are events. -->
            <xsl:element name="members">
                <xsl:apply-templates select="descendant::field[not (@name = preceding-sibling::*/@name)]"/>
              <xsl:apply-templates select="descendant::function[not (@declaring_interface) and not (@name = preceding-sibling::*[not (@declaring_interface)]/@name)]"/>
              <xsl:apply-templates select="descendant::constructor[not (@declaring_interface) and not (@name = preceding-sibling::*[not (@declaring_interface)]/@name)]"/>
              <xsl:apply-templates select="descendant::procedure[not (@declaring_interface) and not (@name = preceding-sibling::*[not (@declaring_interface)]/@name)]"/>
              <xsl:apply-templates select="descendant::destructor[not (@declaring_interface) and not (@name = preceding-sibling::*[not (@declaring_interface)]/@name)]"/>
              <xsl:apply-templates select="descendant::variable[not (@name = preceding-sibling::*/@name)]"/>
              <xsl:apply-templates select="descendant::property[not (@name = preceding-sibling::*/@name)]"/>
              <xsl:apply-templates select="descendant::event[not (@name = preceding-sibling::event/@name)]"/>
            </xsl:element>
            <xsl:if test="self::class | self::helper">
              <xsl:element name="propertylinks">
                <xsl:call-template name="propertylinks"/>
              </xsl:element>
              <xsl:element name="methodlinks">
                <xsl:call-template name="methodlinks"/>
              </xsl:element>
              <xsl:element name="eventlinks">
                <xsl:call-template name="eventlinks"/>
              </xsl:element>
            </xsl:if>
            <!-- this exclusion list excludes members from double processing (they are handled above) and causes us to skip classes and enums in classes - TURNS OUT THIS LOOKS UNNECCESSARY
        <xsl:apply-templates select="*[not(self::interfaces or self::constructor or self::destructor or self::function or self::procedure or self::members or self::property or self::field or self::event or self::variable or self::element or self::class or self::enum)]"/>-->
            <xsl:apply-templates select="attributes|devnotes"/>
          </xsl:element>
        </xsl:if>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="templating" select="."/>
  </xsl:template>
  <xsl:template match="/namespace/class/class/members/constructor |
                     /namespace/class/class/members/destructor |
                     /namespace/class/class/members/procedure |
                     /namespace/class/class/members/function |
                     /namespace/class/class/members/property |
                     /namespace/class/class/members/event |
                     /namespace/class/class/members/variable |
                     /namespace/class/members/class/members/constructor |
                     /namespace/class/members/class/members/destructor |
                     /namespace/class/members/class/members/procedure |
                     /namespace/class/members/class/members/function |
                     /namespace/class/members/class/members/property |
                     /namespace/class/members/class/members/event |
                     /namespace/class/members/class/members/variable">
    <!-- not including inner classes for now -->
    <xsl:apply-templates mode="templating" select="."/>
  </xsl:template>
  <!-- ############# INTERFACE AND CLASS AND STRUCT: #####################
 ######################FUNCTIONS AND PROCEDURES################ -->
  <xsl:template match="/namespace/interface/function 
                     | /namespace/class/members/function
                     | /namespace/struct/function
                     | /namespace/helper/members/function
                     | /helper/members/function

                     | /namespace/interface/constructor
                     | /namespace/struct/constructor
                     | /namespace/class/members/constructor
                     | /namespace/helper/members/constructor
                     | /helper/members/constructor

                     | /namespace/interface/procedure
                     | /namespace/struct/procedure
                     | /namespace/class/members/procedure
                     | /namespace/helper/members/procedure
                     | /helper/members/procedure

                     | /namespace/interface/destructor
                     | /namespace/class/members/destructor
                     | /namespace/struct/destructor
                     | /namespace/helper/members/destructor
                     | /helper/members/destructor">
    <!-- all this gets inserted into interface file in methodcontent -->
    <!-- ASSUMPTION: we won't have a procedure with the same name as
       a function, or similar overlap with constructor & destructor. -->
    <xsl:if test="@declaring_interface">
    </xsl:if>
    <xsl:variable name="name" select="@name"/>
    <xsl:variable name="publishfunction">
      yes
    </xsl:variable>
    <xsl:if test="$publishfunction!='no'">
      <xsl:element name="method">
        <xsl:call-template name="copyattributesandsetvisibility"/>
        <xsl:call-template name="syntax"/>
        <xsl:apply-templates select="*[not(self::parameters)]"/>
      </xsl:element>
    </xsl:if>
    <xsl:apply-templates mode="templating" select="."/>
  </xsl:template>
  <!--################# INTERFACE AND CLASS PROPERTIES ################-->
  <xsl:template match="/namespace/interface/property | /namespace/class/members/property | /namespace/helper/members/property | /helper/members/property | /namespace/struct/members/property | /namespace/struct/property">
    <xsl:variable name="tmpname" select="@name"/>
    <xsl:choose>
      <xsl:when test="preceding-sibling::property[@name=$tmpname]">
        <xsl:message>
          Duplicate <xsl:value-of select="@name"/>
        </xsl:message>
      </xsl:when>
      <xsl:otherwise>
        <xsl:variable name="publishparameter">
    yes
  </xsl:variable>
        <xsl:variable name="name" select="name(.)"/>
        <xsl:if test="$publishparameter!='no'">
          <xsl:element name="{$name}">
            <xsl:call-template name="copyattributesandsetvisibility"/>
            <xsl:call-template name="syntax"/>
            <xsl:apply-templates/>
          </xsl:element>
        </xsl:if>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="templating" select="."/>
  </xsl:template>
  <!-- ############# STRUCT FIELDS ################ -->
  <xsl:template match="/namespace/struct/field | /namespace/class/members/field | /namespace/class/field | /namespace/struct/members/field">
    <xsl:variable name="name" select="@name"/>
    <xsl:choose>
      <xsl:when test="preceding-sibling::field[@name=$name]">
        <xsl:message>
      Duplicate <xsl:value-of select="@name"/>
        </xsl:message>
      </xsl:when>
      <xsl:otherwise>
        <xsl:variable name="publishfield">
    yes
  </xsl:variable>
        <xsl:if test="$publishfield!='no'">
          <xsl:element name="field">
          <!--TODO:replace struct = "" with class = "" for fields not in structs-->
            <xsl:attribute name="struct"><xsl:value-of select="../@name"/></xsl:attribute>
            <xsl:call-template name="copyattributesandsetvisibility"/>
            <xsl:apply-templates/>
          </xsl:element>
        </xsl:if>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="templating" select="."/>
  </xsl:template>
  <!-- ############# INTERFACE EVENTS ################ -->
  <!-- use same for class events? -->
  <xsl:template match="/namespace/interface/event | /namespace/class/members/event">
    <!-- insert into interface file in methodcontent, then into its own file -->
    <xsl:variable name="name" select="@name"/>
    <xsl:choose>
      <xsl:when test="preceding-sibling::event[@name=$name]">
        <xsl:message>
      Duplicate <xsl:value-of select="@name"/>
        </xsl:message>
      </xsl:when>
      <xsl:otherwise>
        <xsl:variable name="publishevent">
    yes
  </xsl:variable>
        <xsl:if test="$publishevent!='no'">
          <xsl:element name="event">
            <xsl:call-template name="copyattributesandsetvisibility"/>
            <xsl:call-template name="syntax"/>
            <xsl:apply-templates/>
          </xsl:element>
        </xsl:if>
      </xsl:otherwise>
    </xsl:choose>
   <xsl:apply-templates mode="templating" select="."/>
  </xsl:template>
  <!-- ############# NAMESPACE-LEVEL FUNCTIONS ################ -->
  <!-- use same for namespace-level procedures? -->
  <xsl:template match="/namespace/function | /namespace/procedure">
    <!-- insert into a new function file -->
    <xsl:variable name="name" select="@name"/>
    <xsl:variable name="previousnode" select="preceding-sibling::function[@name=$name] | preceding-sibling::procedure[@name=$name]"/>
    <xsl:choose>
      <xsl:when test="count(.)=count($previousnode) and count(.)=count(.|$previousnode)">
        <xsl:message>
          Duplicate <xsl:value-of select="@name"/>
        </xsl:message>
      </xsl:when>
      <xsl:otherwise>
        <xsl:variable name="publishfunction">
    yes
  </xsl:variable>
        <xsl:if test="$publishfunction!='no'">
          <!-- only make a file for this function if it is the first
           function with this name -->
          <!-- ASSUMPTION: we won't have a procedure with the same name as
           a function. -->
          <xsl:if test="not (preceding-sibling::function[@name = $name])
      and not (preceding-sibling::procedure[@name = $name])">
            <xsl:element name="routine">
              <xsl:call-template name="copyattributesandsetvisibility"/>
              <xsl:attribute name="namespace"><xsl:value-of select="../@name"/></xsl:attribute>
              <xsl:call-template name="syntax"/>
              <xsl:apply-templates select="*[not(self::parameters)]"/>
            </xsl:element>
          </xsl:if>
        </xsl:if>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="templating" select="."/>
  </xsl:template>
  <!-- ################ SYNTAX ###################### -->
  <xsl:template name="syntax">
    <xsl:element name="syntax">
      <xsl:element name="name">
        <xsl:value-of select="@name"/>
      </xsl:element>
      <xsl:element name="visibility">
        <xsl:value-of select="@visibility"/>
      </xsl:element>
      <!-- SYNTAX: GENERAL ATTRIBUTES -->
      <!-- each of these only applies to some tags, but it won't hurt to
         try them all instead of having a complicated xsl:choose. -->
      <xsl:if test="string-length(@type)>0">
        <xsl:element name="type">
          <xsl:value-of select="@type"/>
        </xsl:element>
      </xsl:if>
      <xsl:if test="string-length(@flags)>0">
        <xsl:element name="flags">
          <xsl:value-of select="@flags"/>
        </xsl:element>
      </xsl:if>
      <xsl:if test="string-length(@procflags)>0">
        <xsl:element name="flags">
          <xsl:value-of select="@procflags"/>
        </xsl:element>
      </xsl:if>
      <xsl:if test="string-length(@callconv)>0">
        <xsl:element name="callconv">
          <xsl:value-of select="@callconv"/>
        </xsl:element>
      </xsl:if>
      <xsl:if test="string-length(@read)>0">
        <xsl:element name="read">
          <xsl:value-of select="@read"/>
        </xsl:element>
      </xsl:if>
      <xsl:if test="string-length(@write)>0">
        <xsl:element name="write">
          <xsl:value-of select="@write"/>
        </xsl:element>
      </xsl:if>
      <xsl:if test="string-length(@add)>0">
        <xsl:element name="add">
          <xsl:value-of select="@add"/>
        </xsl:element>
      </xsl:if>
      <xsl:if test="string-length(@remove)>0">
        <xsl:element name="remove">
          <xsl:value-of select="@remove"/>
        </xsl:element>
      </xsl:if>
      <xsl:element name="variety">
        <xsl:choose>
          <xsl:when test="self::procedure and descendant::retval[translate(@type,$uc,$lc)!='void']">
            <xsl:value-of select="'function'"/>
          </xsl:when>
          <xsl:when test="self::function and translate (descendant::retval/@type,$uc,$lc)='void'">
            <xsl:value-of select="'procedure'"/>
          </xsl:when>
          <xsl:otherwise>
            <xsl:value-of select="name(.)"/>
          </xsl:otherwise>
        </xsl:choose>
      </xsl:element>
      <!-- ###### FUNCTION-SPECIFIC SYNTAX ####### -->
      <xsl:choose>
        <xsl:when test="self::function or self::constructor or self::procedure or self::destructor">
          <xsl:if test="self::function or self::constructor or (self::procedure and ./parameters/retval)">
            <xsl:element name="type">
              <xsl:value-of select="./parameters/retval/@type"/>
            </xsl:element>
          </xsl:if>
          <xsl:call-template name="copyandrenameparameters"/>
        </xsl:when>
        <!-- ###### PROPERTY-SPECIFIC SYNTAX ####### -->
        <xsl:when test="self::property">
          <xsl:variable name="read" select="@read"/>
          <xsl:variable name="write" select="@write"/>
          <xsl:variable name="type" select="@type"/>
          <xsl:for-each select="../function[@name=$read] | 
                              ../procedure[@name=$read]">
            <!-- if has any parameters, insert arrayprop and parameters
               -->
            <xsl:if test="count(parameters/parameter) > 0">
              <xsl:element name="arrayprop">
                <xsl:attribute name="variety">read</xsl:attribute>
                <xsl:apply-templates select="parameters"/>
              </xsl:element>
            </xsl:if>
          </xsl:for-each>
          <!-- same thing now for write methods -->
          <xsl:for-each select="../function[@name=$write] | 
                              ../procedure[@name=$write]">
            <!-- if it has params, insert arrayprop and parameters -->
            <!-- ... unless there is only one parameter and it shares
               the type of the property, then it's just a regular
               "setter" method. -->
            <xsl:if test="count(parameters/parameter) > 0 and not
            (count (parameters/parameter) = 1 and 
            parameters/parameter/@type = $type)">
              <xsl:element name="arrayprop">
                <xsl:attribute name="variety">write</xsl:attribute>
                <xsl:call-template name="copyandrenameparameters"/>
              </xsl:element>
            </xsl:if>
          </xsl:for-each>
        </xsl:when>
        <!-- property -->
      </xsl:choose>
    </xsl:element>
    <xsl:if test="self::struct">
      <xsl:variable name="name" select="@name"/>
      <!-- run syntax once more for next overload -->
      <xsl:for-each select="following-sibling::struct[@name=$name][1]">
        <xsl:call-template name="syntax"/>
      </xsl:for-each>
    </xsl:if>
    <xsl:if test="self::function">
      <xsl:variable name="name" select="@name"/>
      <!-- run syntax once more for next overload -->
      <!-- next function will call it again if there's yet another
         overload -->
      <xsl:for-each select="following-sibling::function[@name=$name][1]">
        <xsl:call-template name="syntax"/>
      </xsl:for-each>
    </xsl:if>
    <xsl:if test="self::procedure">
      <xsl:variable name="name" select="@name"/>
      <!-- run syntax once more for next overload -->
      <!-- next procedure will call it again if there's yet another
         overload -->
      <xsl:for-each select="following-sibling::procedure[@name=$name][1]">
        <xsl:call-template name="syntax"/>
      </xsl:for-each>
    </xsl:if>
  </xsl:template>
  <!-- changes array-typed parameters to the format used by delphi compiler -->
  <xsl:template name="copyandrenameparameters">
    <xsl:element name="parameters">
      <xsl:for-each select="parameters/parameter | parameters/retval">
        <xsl:variable name="elementname" select="name(.)"/>
        <xsl:element name="{$elementname}">
          <xsl:copy-of select="@name"/>
          <xsl:copy-of select="@paramflags"/>
          <xsl:choose>
            <xsl:when test="contains(@type, '[]')">
              <xsl:attribute name="type"><xsl:value-of select="substring-before(@type,'[]')"/></xsl:attribute>
              <xsl:element name="array">
                <xsl:attribute name="name"><xsl:value-of select="@name"/></xsl:attribute>
                <xsl:element name="element">
                  <xsl:attribute name="type"><xsl:value-of select="substring-before(@type,'[]')"/></xsl:attribute>
                </xsl:element>
              </xsl:element>
            </xsl:when>
            <xsl:otherwise>
              <xsl:copy-of select="@type"/>
              <xsl:copy-of select="*"/>
            </xsl:otherwise>
          </xsl:choose>
        </xsl:element>
      </xsl:for-each>
    </xsl:element>
  </xsl:template>
  <!-- CHECK NESTED CLASSES -->
  <!--warn on nested, public classes-->
  <!-- they will not be published! -->
  <xsl:template name="checknestedclasses">
    <xsl:for-each select="class">
      <xsl:if test="@visibility ='public'">
        <xsl:message>

                WARNING: public nested class found! <xsl:value-of select="/namespace/@name"/>.<xsl:value-of select="@name"/>
        </xsl:message>
      </xsl:if>
    </xsl:for-each>
  </xsl:template>
  <!-- GET OUTPUT FILE NAME -->
  <xsl:template name="getoutputfile">
    <xsl:variable name="filename">
      <xsl:choose>
        <xsl:when test="name (.)='namespace'">
          <xsl:value-of select="@name"/>
        </xsl:when>
        <xsl:when test="name (.)='enum' or name (.) = 'set' or name (.)='interface' or name(.)='struct' or name (.)='class'">
          <xsl:value-of select="concat(../@name, '.', @name)"/>
        </xsl:when>
        <xsl:when test="name (.)='function' or name(.)='procedure' 
      or name (.) ='constructor' or name (.) = 'destructor'
      or name (.) ='property' or name(.)='field'">
          <xsl:choose>
            <!-- if top-level function, just use namespace -->
            <xsl:when test="name(..)='namespace'">
              <xsl:value-of select="concat(../@name, '.', 
                                @name)"/>
            </xsl:when>
            <!-- otherwise it belongs to a class or interface, so include
             that name too... -->
            <xsl:otherwise>
              <xsl:value-of select="concat(ancestor::namespace/@name, '.', ancestor::class/@name | ancestor::struct/@name | ancestor::interface/@name, '.',
                                @name)"/>
            </xsl:otherwise>
          </xsl:choose>
        </xsl:when>
        <xsl:when test="self::variable or self::const or self::enum or self::set or self::type or self::array or self::pointer or self::classref">
          <xsl:choose>
            <!-- if top-level variable, just use namespace -->
            <xsl:when test="name(..)='namespace'">
              <xsl:value-of select="concat(../@name, '.', 
                                @name)"/>
            </xsl:when>
            <!-- otherwise it belongs to a struct, so include
             that name too... -->
            <xsl:otherwise>
              <xsl:if test="ancestor::struct">
                <xsl:value-of select="concat(ancestor::namespace/@name, '.', ancestor::struct/@name, '.', @name)"/>
              </xsl:if>
              <xsl:if test="ancestor::class">
                <xsl:value-of select="concat(ancestor::namespace/@name, '.', ancestor::class/@name, '.', @name)"/>
              </xsl:if>
            </xsl:otherwise>
          </xsl:choose>
        </xsl:when>
        <xsl:otherwise>
          <xsl:value-of select="'UNKNOWN_OUTPUT_FILE_'"/>
          <xsl:message>
          UNKNOWN OUTPUT FILE: <xsl:copy-of select="."/>
          </xsl:message>
        </xsl:otherwise>
      </xsl:choose>
    </xsl:variable>
    <xsl:value-of select="concat($filename,'.xml')"/>
    <!--<xsl:value-of select="concat($filename,'_',name(.),'.xml')"/>-->
  </xsl:template>
  <!-- this template goes through each attribute.  If the attribute is
     in the string, it copies the attribute and calls itself with the
     remaining string.  If the attribute is not in the string, it
     gives an error message. -->
  <!-- nahh, for-each is easier -->
  <xsl:template name="handleattributes">
    <xsl:param name="copystring"/>
    <xsl:param name="ignorestring"/>
    <xsl:for-each select="@*">
      <xsl:choose>
        <xsl:when test="contains($copystring, name(.))">
          <!-- copy the attribute -->
          <xsl:copy-of select="."/>
        </xsl:when>
        <xsl:otherwise>
          <xsl:if test="not(contains($ignorestring, name(.)))">
            <!-- give an error message -->
            <xsl:message>
              <xsl:variable name="path">
                <xsl:call-template name="getfullxpath"/>
              </xsl:variable>
              <xsl:text>Unexpected attribute: </xsl:text>
              <xsl:value-of select="$path"/>
              <xsl:text> -- </xsl:text>
              <xsl:value-of select="name(.)"/>
              <xsl:text>, copy </xsl:text>
              <xsl:value-of select="$copystring"/>
              <xsl:text>, ignore</xsl:text>
              <xsl:value-of select="$ignorestring"/>
            </xsl:message>
          </xsl:if>
        </xsl:otherwise>
      </xsl:choose>
    </xsl:for-each>
    <!-- insert public visibility if it doesn't exist -->
    <xsl:if test="contains($copystring,'visibility') and
                  not(@visibility)">
      <xsl:attribute name="visibility">public</xsl:attribute>
      <xsl:attribute name="visibility-generated">yes</xsl:attribute>
    </xsl:if>
  </xsl:template>
  <!-- ### GET FULL XPATH ### -->
  <xsl:template name="getfullxpath">
    <xsl:param name="fromnode"/>
    <xsl:for-each select="ancestor::*[name(.)!='product' and name(.) != 'structure' and name(.)!='currentproduct' and name(.)!='products']">
      <!-- append this name to the output -->
      <xsl:text>/</xsl:text>
      <xsl:value-of select="name(.)"/>
    </xsl:for-each>
    <!-- append the current name to the output -->
    <xsl:text>/</xsl:text>
    <xsl:value-of select="name(.)"/>
  </xsl:template>
  <!-- ### GET ABBREVIATED XPATH (NO SLASHES) ### -->
  <xsl:template name="getabbrevxpath">
    <xsl:param name="fromnode"/>
    <xsl:for-each select="ancestor::*[name(.)!='product' and name(.) != 'structure' and name(.)!='currentproduct' and name(.)!='products']">
      <!-- append this name to the output -->
      <xsl:value-of select="name(.)"/>
    </xsl:for-each>
    <!-- append the current name to the output -->
    <xsl:value-of select="name(.)"/>
  </xsl:template>
  <xsl:template name="copyattributesandsetvisibility">
    <xsl:copy-of select="@*"/>
    <xsl:if test="not(@visibility)">
      <xsl:attribute name="visibility">public</xsl:attribute>
      <xsl:attribute name="visibility-generated">yes</xsl:attribute>
    </xsl:if>
  </xsl:template>
  <xsl:template match="value|devnotes|element">
    <xsl:variable name="name">
      <xsl:value-of select="name(.)"/>
    </xsl:variable>
    <xsl:element name="{$name}">
      <xsl:copy-of select="@*"/>
      <xsl:apply-templates/>
    </xsl:element>
  </xsl:template>
  <!--Routing template to extract needed info-->
  <xsl:template match="*[not(ancestor-or-self::devnotes)]" mode="templating">
       <xsl:variable name="dirname">
      <!--<xsl:text>C:\cvs\BuildEnvironment\customerbuild\APInorm</xsl:text>-->
      <xsl:choose>
        <xsl:when test="child::devnotes">content\</xsl:when>
        <xsl:otherwise>templates\</xsl:otherwise>
      </xsl:choose>
      <xsl:value-of select="ancestor::namespace/@name"/>
      <xsl:choose>
        <!--Classes -->
        <xsl:when test="ancestor-or-self::*[name()='interface' or name()='class']">
          <xsl:text>\classes</xsl:text>
          <xsl:text>\</xsl:text>
          <!-- Classes get a subdirectory with the name of the class below the "classes" directory.-->
          <xsl:value-of select="ancestor-or-self::*[name()='interface' or name()='class']/@name"/>
          <!-- Handle members directories-->
          <xsl:if test="ancestor::members">
            <xsl:choose>
              <xsl:when test="self::property or self::variable">
                <xsl:text>\Properties</xsl:text>
              </xsl:when>
              <xsl:when test="self::field">
				  <xsl:text>\Fields</xsl:text>
              </xsl:when>
              <xsl:when test="self::procedure or self::constructor or self::function or self::destructor">
                <xsl:text>\Methods</xsl:text>
              </xsl:when>
              <xsl:when test="self::event">
                <xsl:text>\Events</xsl:text>
              </xsl:when>
            </xsl:choose>
          </xsl:if>
        </xsl:when>
        <!--Types -->
        <xsl:when test="ancestor-or-self::*[not(ancestor::class)][name()='enum' or name()='array' or name()='classref' or name()='helper' or name()='pointer' or name()='set' or name()='struct' or name()='type']">
          <xsl:text>\types</xsl:text>
          <xsl:text>\</xsl:text>
          <!-- Always generate types directories with the name of the type (just to be consistent, since I can't find any logical pattern to the current API directories for types)-->
          <xsl:value-of select="ancestor-or-self::*[name()='enum' or name()='array' or name()='classref' or name()='helper' or name()='pointer' or name()='set' or name()='struct' or name()='type']/@name"/>
        </xsl:when>
        <!-- Routines -->
        <xsl:when test="ancestor-or-self::*[not(ancestor::class)][name()='function' or name()='procedure']">
          <xsl:text>\routines</xsl:text>
        </xsl:when>
        <!-- Constants -->
        <xsl:when test="ancestor-or-self::const">
          <xsl:text>\constants</xsl:text>
        </xsl:when>
        <!-- Variables -->
        <xsl:when test="ancestor-or-self::variable">
          <xsl:text>\variables</xsl:text>
        </xsl:when>
      </xsl:choose>
    </xsl:variable>
    <!-- Generate type name-->
    <xsl:variable name="type">
      <xsl:choose>
        <xsl:when test="self::*[name()='interface' or name()='class']">class</xsl:when>
        <xsl:when test="self::*[name()='enum' or name()='array' or name()='classref' or name()='helper' or name()='pointer' or name()='set' or name()='struct' or name()='type']">type</xsl:when>
        <xsl:when test="self::*[name()='function' or name()='procedure']">routine</xsl:when>
        <xsl:when test="self::const">constant</xsl:when>
        <xsl:when test="self::variable">variable</xsl:when>
        <xsl:when test="self::property">property</xsl:when>
        <xsl:when test="self::procedure or self::constructor or self::function or self::destructor">method</xsl:when>
        <xsl:when test="self::event">event</xsl:when>
        <xsl:when test="self::field">field</xsl:when>
      </xsl:choose>
    </xsl:variable>
    <xsl:variable name="filename">
    <xsl:if test="ancestor::class">
      <xsl:value-of select="ancestor::class[1]/@name"/><xsl:text>.</xsl:text><!--Classname(dot)PME name-->
      </xsl:if>
		<xsl:variable name="innerclass">
			<xsl:choose>
				<xsl:when test="contains(@name, '.')">
					<xsl:value-of select="substring-after(@name,'.')"/>
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of select="@name"/>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		<xsl:value-of select="$innerclass"/>
    </xsl:variable>
    <xsl:call-template name="makeTemplates">
      <xsl:with-param name="dirName" select="$dirname"/>
      <xsl:with-param name="filename" select="$filename"/>
      <xsl:with-param name="type" select="$type"/>
    </xsl:call-template>
  </xsl:template>
  <!-- To get the templating to work, we need to create a java file object which is a directory.-->
  <!-- most of these params can be extracted from the node context.  Really just need dir name and types.-->
  <xsl:template name="makeTemplates">
    <xsl:param name="dirName"/>
    <xsl:param name="filename"/>
    <xsl:param name="type"/>
        <!-- <xsl:param name="namespace"/>
    <xsl:param name="class"/>
    <xsl:param name="fileName"/>
    <xsl:param name="devnotes"/>-->
    <xsl:variable name="class" select="ancestor::class[1]/@name"/>
    <xsl:variable name="namespace" select="ancestor::namespace/@name"/>
    <!--refactor into global variable and clean up code-->
    <xsl:variable name="dir" select="javaFile:new($dirName)"/>
    <xsl:variable name="madeDir" select="javaFile:mkdirs($dir)"/>
    <xsl:if test="javaFile:exists($dir)">
      <xsl:document href="{$dirName}/{$filename}.xml">
        
        <api>
          <!-- xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xsi:noNamespaceSchemaLocation="../../../../../../../xconfig/schemas/classInterface.xsd">-->
          <!-- Type, namespace, possibly class, element name tag-->
          <xsl:element name="{$type}">
            <xsl:attribute name="namespace"><xsl:value-of select="$namespace"/></xsl:attribute>
            <xsl:if test="$class">
              <xsl:attribute name="class"><xsl:value-of select="$class"/></xsl:attribute>
            </xsl:if>
            <xsl:value-of select="@name"/>
          </xsl:element>
          <!-- End type, namespace, class, element name-->
	 
		 <!-- if there's a summary tag, use that for descrShort; otherwise use first devnotes node -->
		 <xsl:choose>
				<xsl:when test="devnotes/summary">
          <descrShort id="descrShort">
            <!-- summary turns into descrShort-->
            <xsl:apply-templates select="devnotes/summary" mode="templating"/>
          </descrShort>
          <descrLong id="descrLong">
            <!-- All child devnotes turn into paras inside the long descr-->
            <xsl:apply-templates select="devnotes[not(child::summary)] | devnotes[child::summary]/text() | devnotes[child::summary]/*[name()!='summary']" mode="templating"/>
          </descrLong>				
				</xsl:when>
				<xsl:otherwise>
          <descrShort id="descrShort">
            <!-- First child devnote turns into descrShort-->
            <xsl:apply-templates select="child::devnotes[1]" mode="templating"/>
          </descrShort>
          <descrLong id="descrLong">
            <!-- All child devnotes turn into paras inside the long descr-->
            <xsl:apply-templates select="child::devnotes" mode="templating"/>
          </descrLong>				
				</xsl:otherwise>
			</xsl:choose>
 

          <!-- <linkList xlinkType="simple">
	   </linkList>-->
        </api>
      </xsl:document>
    </xsl:if>
  </xsl:template>
  <xsl:template match="devnotes" mode="templating">
    <para>
      <xsl:apply-templates mode="templating"/>
    </para>
  </xsl:template>
  <xsl:template match="*[ancestor::devnotes]" mode="templating">
  <xsl:copy xml:space="default"><xsl:apply-templates/></xsl:copy>
    </xsl:template>
  <xsl:template match="variable">
    <xsl:element name="variable">
      <xsl:call-template name="copyattributesandsetvisibility"/>
    </xsl:element>
  </xsl:template>
  <xsl:template match="attributes">
    <xsl:element name="attributes">
      <xsl:copy-of select="attribute"/>
    </xsl:element>
  </xsl:template>
</xsl:stylesheet>
